@extends('layouts.app')

@section('title', 'Create Prescription')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6 flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
        <h1 class="text-3xl font-bold text-gray-800">Create Prescription</h1>
        <a href="{{ auth()->user()->isDoctor() ? route('doctor.dashboard') : (auth()->user()->isAdmin() ? route('admin.dashboard') : route('pharmacist.dashboard')) }}" 
           class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded">
            <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
        </a>
    </div>

    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <h2 class="text-xl font-bold mb-4">Patient Information</h2>
        <div class="grid grid-cols-2 gap-4">
            <div><strong>Name:</strong> {{ $appointment->patient->full_name }}</div>
            <div><strong>ID:</strong> {{ $appointment->patient->patient_id }}</div>
            <div><strong>DOB:</strong> {{ $appointment->patient->date_of_birth?->format('Y-m-d') ?? 'N/A' }}</div>
            <div><strong>Gender:</strong> {{ $appointment->patient->gender ?? 'N/A' }}</div>
        </div>
    </div>

    <form method="POST" action="{{ route('prescriptions.store', $appointment->id) }}" class="bg-white rounded-lg shadow p-6">
        @csrf

        <div class="mb-6">
            <label class="block text-gray-700 text-sm font-bold mb-2">Diagnosis</label>
            <textarea name="diagnosis" rows="3" class="w-full px-3 py-2 border rounded">{{ old('diagnosis') }}</textarea>
        </div>

        <div class="mb-6">
            <label class="block text-gray-700 text-sm font-bold mb-2">Additional Prescription Details</label>
            <textarea name="additional_prescription_details" rows="3" class="w-full px-3 py-2 border rounded">{{ old('additional_prescription_details') }}</textarea>
        </div>

        <div class="mb-6">
            <h3 class="text-lg font-bold mb-4">Prescription Items</h3>
            <div id="items-container">
                <div class="item-row mb-4 p-4 border rounded">
                    <div class="grid grid-cols-5 gap-4 mb-4">
                        <div>
                            <label class="block text-gray-700 text-sm font-bold mb-2">Medicine Name *</label>
                            <input type="text" name="items[0][medicine_name]" required class="w-full px-3 py-2 border rounded">
                        </div>
                        <div>
                            <label class="block text-gray-700 text-sm font-bold mb-2">Dosage *</label>
                            <input type="text" name="items[0][dosage]" required class="w-full px-3 py-2 border rounded">
                        </div>
                        <div>
                            <label class="block text-gray-700 text-sm font-bold mb-2">Frequency *</label>
                            <input type="text" name="items[0][frequency]" required class="w-full px-3 py-2 border rounded">
                        </div>
                        <div>
                            <label class="block text-gray-700 text-sm font-bold mb-2">Instructions</label>
                            <input type="text" name="items[0][instructions]" class="w-full px-3 py-2 border rounded">
                        </div>
                        <div>
                            <label class="block text-gray-700 text-sm font-bold mb-2">Duration *</label>
                            <input type="text" name="items[0][duration]" required class="w-full px-3 py-2 border rounded">
                        </div>
                    </div>
                </div>
            </div>
            <button type="button" onclick="addItem()" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded">
                <i class="fas fa-plus"></i> Add Item
            </button>
        </div>

        <div class="flex justify-end">
            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded">
                Create Prescription
            </button>
        </div>
    </form>
</div>

<script>
let itemCount = 1;

function addItem() {
    const container = document.getElementById('items-container');
    const newItem = document.createElement('div');
    newItem.className = 'item-row mb-4 p-4 border rounded';
    newItem.innerHTML = `
        <div class="grid grid-cols-5 gap-4 mb-4">
            <div>
                <label class="block text-gray-700 text-sm font-bold mb-2">Medicine Name *</label>
                <input type="text" name="items[${itemCount}][medicine_name]" required class="w-full px-3 py-2 border rounded">
            </div>
            <div>
                <label class="block text-gray-700 text-sm font-bold mb-2">Dosage *</label>
                <input type="text" name="items[${itemCount}][dosage]" required class="w-full px-3 py-2 border rounded">
            </div>
            <div>
                <label class="block text-gray-700 text-sm font-bold mb-2">Frequency *</label>
                <input type="text" name="items[${itemCount}][frequency]" required class="w-full px-3 py-2 border rounded">
            </div>
            <div>
                <label class="block text-gray-700 text-sm font-bold mb-2">Instructions</label>
                <input type="text" name="items[${itemCount}][instructions]" class="w-full px-3 py-2 border rounded">
            </div>
            <div>
                <label class="block text-gray-700 text-sm font-bold mb-2">Duration *</label>
                <input type="text" name="items[${itemCount}][duration]" required class="w-full px-3 py-2 border rounded">
            </div>
        </div>
        <button type="button" onclick="removeItem(this)" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded">
            <i class="fas fa-trash"></i> Remove
        </button>
    `;
    container.appendChild(newItem);
    itemCount++;
}

function removeItem(button) {
    button.closest('.item-row').remove();
}
</script>
@endsection

